#include <stdio.h>
#include <winsock.h>
#include <time.h>

#define KORTA "korta\r\n" 
#define UZTEKS "uzteks\r\n"
#define ZAISTI "zaisti\r\n"

#pragma comment (lib, "wsock32.lib")

int countServer=0;
int countCard=0;

// --------------------------------------------------------------- start_server
int start_server(SOCKET s, unsigned short portnum)
{
	char myname[256];
	struct sockaddr_in sa;
	struct hostent *hp;

	memset(&sa, 0, sizeof(struct sockaddr_in)); ///Apnulinam adresa
	gethostname(myname, sizeof(myname));        ///Paima kompiuterio varda
	hp = gethostbyname(myname);					///Uzpildo hostent struktura ir gauna ip
	if (hp == NULL) {
		return -1;
	};

	sa.sin_family = hp->h_addrtype;             ///Host adresas
	sa.sin_port = htons(portnum);               ///Porto numeris

	///Ip susiejam su soketu
	if (bind(s, (struct sockaddr *)&sa, sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
		closesocket(s);
		return -2;
	}

	listen(s, 3);

	return 0;
}

class Socket
{
public:
	   Socket()                                       ///Prisijungia clientas
	   {
		   	///Inicializuojam WinSock biblioteka
			WSADATA info;
			if (WSAStartup(MAKEWORD(1,1), &info) != 0)
			{
				printf("*** Cannot initialize WinSock - WSAStartup() failed\n");
				exit(-1);
			}

			///Sukuriam soketa
			s = socket(AF_INET, SOCK_STREAM, 0);
			if (s == INVALID_SOCKET)
			{
				printf("*** Cannot create socket - socket() failed\n");
				exit(-1);
			};
			
			start_server(s, 1234);

			printf("*** Server started\n");

		}


	   SOCKET accept(){return ::accept(s, NULL, NULL);};               ///Musu accept() iskviecia Windowsinie accept, istrinant nereikalingus parametrus
	   void send(SOCKET new_sock, char * data ){::send( new_sock,data,(int)strlen(data), 0);};

	   SOCKET s;

};


// ----------------------------------------------------------------------- main
int main()
{
		srand( time(NULL));
		Socket s;	

		///Laukiam cliento
		while (true)
		{
			SOCKET new_sock = s.accept();                ///Darbui su duomenimis

			printf("Prisijungimas pavyko\n");
			
			if (new_sock == INVALID_SOCKET)
			{
				fprintf(stderr, "Error waiting for new connection!\n");
				exit(1);
			}
		
			s.send(new_sock,"	SVEIKI ATVYKE :) !!!\n");
			
			do
			{
				char buf[2] = "0";
				char output[255] = "";
			
				///Skaito eilute is cliento
				while (buf[0] != '\n')
				{
					if (recv(new_sock, buf, 1, 0) > 0)
					{
						printf("%c",buf[0]);
						strncat(output, buf, 1);
					};
				};
				
				if(!strcmp(output, KORTA))
				{
					int rnd = rand();
					float ff= (rnd/(float)RAND_MAX);  // [0,1]
					int korta= (int)(1+11*ff);
					//int ff=1+(rand()%11);
					countCard += korta;
					char  bufer[255];
					sprintf(bufer,"%d\r\n",korta);
					s.send( new_sock, bufer);
				}
				else
				if(!strcmp(output, UZTEKS))
				{
					char szServerCard[255]="";
					char buf[255]="";
					int n=0;
					
					while(countServer<=10 )
					{
						n=1+(rand()%11);
						countServer +=n;
						sprintf(buf,"%d ",n);
						strcat(szServerCard,buf);
					};
					
						n=1+(rand()%11);
						countServer +=n;
						sprintf(buf,"%d ",n);
						strcat(szServerCard,buf);
					
					sprintf(buf," PRIESININKO TASKAI: %d ",countServer);
					strcat(szServerCard,buf);
					
					sprintf(buf,"	JUSU TASKAI: %d ",countCard);
					strcat(szServerCard,buf);

					if(countCard>21)
					{
						strcpy(szServerCard,"  REZULTATAS: JUS PRALAIMEJOT SVEIKINU\r\n");
					}
					else
					if(countServer>21)
					{
						strcat(szServerCard,"						REZULTATAS: JUS LAIMEJOT SVEIKINU\r\n");
					}
					else
					if(countServer < countCard)
					{
						strcat(szServerCard,"  REZULTATAS: JUS LAIMEJOT SVEIKINU\r\n");
					}
					else
					if(countServer > countCard)
					{
						strcat(szServerCard,"  REZULTATAS: JUS PRALAIMEJOT SVEIKINU :)\r\n");
					}
					else
					if(countServer == countCard)
					{
							strcat(szServerCard,"  REZULTATAS: LYGIOSIOS\r\n");
					}

					s.send( new_sock, szServerCard);
				}
				else
				if(!strcmp(output, ZAISTI))
				{
					countServer=0;
					countCard=0;
					s.send( new_sock, "TRAUKIT KORTA\r\n");
				}

				if (!strcmp(output,buf))
				{
					countServer=0;
					countCard=0;
					s.send( new_sock, "TRAUKIT KORTA\r\n");
				}
				
				if (!strcmp(output,"iseiti\r\n"))
				{
					char* bye_str = "Bye\n";
					s.send(new_sock, bye_str);
					closesocket(new_sock);

					printf("*** Client disconnected\n");
					break;
				}
				
			} while (true); //end do
		} //end while

	return 0;
}
